module load GATK/3.8.1

INVCF=FULL_IBD_SSV456_hg38.vcf.gz #vcf restricted to required capture kit
OUTVCF=FULL_IBD_postfilt.vcf.gz

module load biobuilds
## Apply first set of filters DP and GQ. This step does not actively remove variants but replace low-quality genotypes with missing (./.)
vcftools --gzvcf $INVCF --minDP 8 --minGQ 20 --recode-INFO-all --recode --out IBD_GQ_DP_filt

## Use script meanGQ_filter.sh to filter for meanGQ>35
#remember to clean temp* between the two steps. Syntax is meanGQ_filter.sh input_vcf output_vcf
meanGQ_filter.sh IBD_GQ_DP_filt IBD_GQ_DP_meanGQ_filt.vcf 


## Apply callrate filter, snp has to be genotyped in at least 88% of the cohort
vcftools --vcf IBD_GQ_DP_meanGQ_filt.vcf --max-missing 0.88 --recode-INFO-all --recode --out $OUTVCF

